function triangle = sgrtriangle( z, vshale)

steps = 200;

throwmax = z(end) - z(1);


triangle = zeros( length(z), steps);

idx = 1;
for throw = linspace( 0,  throwmax, steps)
    sgr = calculatesgr( z, vshale, throw);
    triangle(:, idx) = sgr;
    idx = idx + 1;
end

imagesc( linspace( 0,  throwmax, steps), z, triangle), hold on

hidenans


xlabel('throw')
ylabel('z');
% contour( linspace( 0,  throwmax, steps), z, triangle, .25, 'r')


function hidenans
sgrmin=min(triangle(:));
sgrmax=max(triangle(:));
%# size of colormap

[im,cmap] = imread('D:\Matlab\code\sgrcolorscheme.png');
cm = double(squeeze(im))/255;
n = size(cm,1);
%# color step
dmap=(sgrmax-sgrmin)/n;

%# add nan color to colormap
colormap([1 1 1; cm]);
%# changing color limits
caxis([sgrmin-dmap sgrmax]);
%# place a colorbar
hcb = colorbar;
%# change Y limit for colorbar to avoid showing NaN color
ylim(hcb,[sgrmin sgrmax])
end

end